import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.booking_yang.server.lib import Application

config = ConfigLoader(
    Option("DATABASE_URL"),
    Option("DOORMAN_TVM", default="doorman"),
    Option("DOORMAN_URL", default=None),
    Option("GEO_PRODUCT_BIZ_OWNER_UID", default=None, converter=int),
    Option("GEO_PRODUCT_URL", default=None),
    Option("GEO_SEARCH_URL", default=None),
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option("WARDEN_TASKS", default=(), converter=converters.Tuple()),
    Option("WARDEN_URL", default=None),
    Option("YANG_POOL_ID", default=None),
    Option("YANG_TOKEN", default=None),
    Option("YANG_URL", default=None),
    Option("YASMS_SENDER", default=None),
    Option("YASMS_URL", default=None),
    Option("NEW_YANG_FORMAT", default=False, converter=converters.Bool()),
    Option("DISCONNECT_ORGS", default=False, converter=converters.Bool()),
    Option("YT_CLUSTER", default="hahn"),
    Option("YT_TOKEN", default=None),
    Option("YT_EXPORT_CREATED_ORDERS", default=None),
    Option("YT_EXPORT_ORDERS_PROCESSED_BY_YANG_TABLE", default=None),
    Option("YT_EXPORT_ORDERS_NOTIFIED_TO_USERS_TABLE", default=None),
    Option(
        "TVM_WHITELIST", default=(), converter=converters.Tuple(element_converter=int)
    ),
    Option(
        "TVM_GDPR_WHITELIST",
        default=(),
        converter=converters.Tuple(element_converter=int),
    ),
)

arg_parser = argparse.ArgumentParser("Booking-Yang")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
