from aiohttp import web

from maps_adv.geosmb.booking_yang.server.lib.domains import OrdersDomain

from .middlewares import handle_domain_errors, handle_validation_errors
from .providers import ApiProvider
from .resources import Resources
from .sensors import Sensors


def create(orders_domain: OrdersDomain) -> web.Application:
    api = web.Application(middlewares=[handle_validation_errors, handle_domain_errors])

    resources = Resources(ApiProvider(orders_domain))
    sensors = Sensors(orders_domain)

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.get("/product_sensors/", sensors.handler),
            web.post("/v1/orders/", resources.make_order),
            web.post("/v1/list_client_orders/", resources.list_client_orders),
            web.post("/v1/fetch_actual_orders/", resources.fetch_actual_orders),
            web.post(
                "/internal/v1/clear_orders_for_gdpr/", resources.clear_orders_for_gdpr
            ),
            web.post(
                "/internal/v1/search_orders_for_gdpr/",
                resources.search_orders_for_gdpr,
            ),
        ]
    )

    return api
