from aiohttp.web import Request, Response, json_response

from maps_adv.common.lasagna import tvm_auth

from .providers import ApiProvider

__all__ = ["Resources"]


class Resources:
    __slots__ = ("_provider",)

    _provider: ApiProvider

    def __init__(self, provider: ApiProvider):
        self._provider = provider

    async def make_order(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.make_order(data=body)

        return Response(status=201, body=result)

    async def list_client_orders(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_client_orders(data=body)

        return Response(status=200, body=result)

    async def fetch_actual_orders(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.fetch_actual_orders(data=body)

        return Response(status=200, body=result)

    async def ping(self, _) -> Response:
        return json_response(status=204)

    @tvm_auth.only("TVM_GDPR_WHITELIST")
    async def clear_orders_for_gdpr(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.clear_orders_for_gdpr(data=body)

        return Response(status=200, body=result)

    @tvm_auth.only("TVM_GDPR_WHITELIST")
    async def search_orders_for_gdpr(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.search_orders_for_gdpr(data=body)

        return Response(status=200, body=result)
