from aiohttp.web import Request, Response
from aiohttp.web_response import json_response

from maps_adv.geosmb.booking_yang.server.lib.domains import OrdersDomain


class Sensors:
    __slots__ = ("_domain",)

    _domain: OrdersDomain

    def __init__(self, domain: OrdersDomain):
        self._domain = domain

    async def handler(self, request: Request) -> Response:
        lasagna_app = request.app["lasagna"]

        tasks_count = await self._domain.fetch_pending_yang_tasks_count()
        lasagna_app.product_sensors.take("pending_yang_tasks").add(tasks_count)
        data = lasagna_app.product_sensors.serialize()

        return json_response(data, status=200)
