create_order = """
    INSERT INTO orders (
        permalink, reservation_datetime, reservation_timezone, person_count,
        customer_name, customer_phone, customer_passport_uid, comment,
        call_agreement_accepted, biz_id, time_to_call, created_at
    )
    VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12)
    RETURNING (id)
"""

retrieve_order_by_suite = """
    SELECT *
    FROM orders
    WHERE yang_suite_id = $1
        AND task_result_got_at IS NULL
"""

retrieve_earliest_unprocessed_order_time = """
    SELECT MIN(yang_task_created_at)
    FROM orders
    WHERE task_result_got_at IS NULL
"""

list_pending_orders = """
    SELECT id,
        permalink,
        reservation_datetime,
        reservation_timezone,
        person_count,
        customer_name,
        customer_phone,
        comment,
        created_at
    FROM orders
    WHERE yang_suite_id IS NULL
        AND time_to_call <= $1
    ORDER BY created_at
    FOR UPDATE SKIP LOCKED
"""

list_orders_without_client = """
    SELECT id,
        biz_id,
        customer_name,
        customer_phone,
        customer_passport_uid,
        created_at
    FROM orders
    WHERE client_id IS NULL
        AND biz_id IS NOT NULL
        AND created_at <= $1
    ORDER BY created_at
"""

list_orders_for_sending_result_event = """
    SELECT id,
        biz_id,
        client_id,
        booking_verdict AS verdict
    FROM orders
    WHERE biz_id IS NOT NULL
        AND client_id IS NOT NULL
        AND booking_verdict IS NOT NULL
        AND sent_result_event_at IS NULL
    ORDER BY created_at
"""

update_orders = """
    UPDATE orders SET
    {set_pairs_str}
    WHERE id = ANY($1)
"""

select_order_for_update = """
    SELECT
    FROM orders
    WHERE id = $1
    FOR UPDATE SKIP LOCKED
"""

retrieve_orders_for_sending_sms = """
    SELECT id,
        reservation_datetime,
        reservation_timezone,
        customer_phone,
        customer_name,
        booking_verdict,
        booking_meta
    FROM orders
    WHERE sms_sent_at IS NULL
        AND task_result_got_at IS NOT NULL
    ORDER BY created_at
"""

iter_created_orders = """
    SELECT id AS order_id, created_at, time_to_call as processing_time
    FROM orders
    WHERE exported_as_created_at IS NULL
    ORDER BY created_at
"""

iter_orders_submitted_to_yang = """
    SELECT
        id AS order_id,
        yang_suite_id,
        yang_task_created_at,
        task_created_at,
        task_result_got_at
    FROM orders
    WHERE yang_suite_id IS NOT NULL
        AND exported_as_processed_at IS NULL
        AND task_result_got_at IS NOT NULL
    ORDER BY task_created_at
"""

iter_orders_notified_to_users = """
    SELECT
        id AS order_id,
        yang_suite_id,
        booking_verdict,
        sms_sent_at
    FROM orders
    WHERE yang_suite_id IS NOT NULL
        AND sms_sent_at IS NOT NULL
        AND exported_as_notified_at IS NULL
    ORDER BY sms_sent_at
"""

list_client_orders = """
    WITH client_orders AS (
        SELECT
            id AS order_id,
            created_at,
            reservation_datetime,
            reservation_timezone,
            person_count,
            (
                CASE
                    WHEN booking_verdict is NULL THEN 'UNPROCESSED'
                    WHEN booking_verdict = 'booked' THEN 'ACCEPTED'
                    ELSE 'REJECTED'
                END
            ) AS status
        FROM orders
        WHERE client_id = $1 AND biz_id = $2
    ),
    events_beyond_period_counts AS (
        SELECT
            count(*) FILTER (WHERE reservation_datetime < $3) AS events_before,
            count(*) FILTER (WHERE reservation_datetime > $4) AS events_after
        FROM client_orders
    )
    SELECT
        co.order_id,
        co.created_at,
        co.reservation_datetime,
        co.reservation_timezone,
        co.person_count,
        co.status,
        ec.events_before,
        ec.events_after
    FROM client_orders AS co
    RIGHT JOIN events_beyond_period_counts AS ec ON TRUE
    {period_conditions}
    ORDER BY reservation_datetime DESC
"""


fetch_pending_yang_tasks_count = """
    SELECT COUNT(*)
    FROM orders
    WHERE yang_task_created_at IS NOT NULL
        AND task_result_got_at IS NULL
"""


list_actual_orders_for_personal_poi = """
    SELECT
        client_id,
        permalink,
        customer_passport_uid as passport_uid,
        reservation_datetime,
        reservation_timezone
    FROM orders
    WHERE booking_verdict = 'booked'
        AND reservation_datetime >= $1
        AND (
            client_id IS NOT NULL
            OR customer_passport_uid IS NOT NULL
        )
    ORDER BY reservation_datetime
"""


clear_orders_by_passport = """
    UPDATE orders
    SET customer_passport_uid = NULL,
        customer_name = NULL,
        customer_phone = NULL
    WHERE customer_passport_uid = $1
    RETURNING id AS order_id
"""


check_orders_existence_by_passport = """
    SELECT EXISTS(
        SELECT 1
        FROM orders
        WHERE customer_passport_uid = $1
    )
"""
