CREATE TABLE orders (
    id bigserial PRIMARY KEY,
    permalink bigint NOT NULL,
    reservation_datetime timestamptz NOT NULL,
    reservation_timezone text NOT NULL,
    person_count int NOT NULL,
    customer_name text NOT NULL,
    customer_phone text NOT NULL,
    comment text NOT NULL,
    call_agreement_accepted boolean NOT NULL,
    yang_suite_id text,
    biz_id bigint,
    client_id bigint,
    created_at timestamptz NOT NULL DEFAULT NOW(),
    sms_sent_at timestamptz,
    task_created_at timestamptz,
    booking_verdict text,
    booking_meta jsonb,
    exported_as_processed_at timestamptz,
    exported_as_notified_at timestamptz,
    -- time_to_call will be None if do not have enough time to call org
    time_to_call timestamptz,
    exported_as_created_at timestamptz,
    -- actual task created time
    task_result_got_at timestamptz,
    -- task_created_at, yang version
    yang_task_created_at timestamptz
);

CREATE UNIQUE INDEX ix_orders_yang_suite_id
ON orders
USING btree (yang_suite_id);

CREATE INDEX ix_orders_time_to_call
ON orders
USING btree (time_to_call);

CREATE INDEX ix_orders_task_created_at
ON orders
USING btree (task_created_at);
