from enum import Enum, auto

from maps_adv.geosmb.booking_yang.proto.orders_pb2 import ClientOrder


class OrderStatus(Enum):
    UNPROCESSED = auto()
    REJECTED = auto()
    ACCEPTED = auto()


ENUMS_MAP = {
    "order_status": [
        (ClientOrder.OrderStatus.UNPROCESSED, OrderStatus.UNPROCESSED),
        (ClientOrder.OrderStatus.ACCEPTED, OrderStatus.ACCEPTED),
        (ClientOrder.OrderStatus.REJECTED, OrderStatus.REJECTED),
    ]
}
