PY3TEST()

OWNER(g:geosmb)

SUBSCRIBER(scomip)

SRCDIR(maps_adv/geosmb/booking_yang/server)

PEERDIR(
    contrib/python/aresponses
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    smb/common/pgswim/pytest
    smb/common/testing_utils

    smb/common/aiotvm/pytest
    maps_adv/common/lasagna/pytest
    maps_adv/common/shared_mock/pytest

    maps_adv/geosmb/clients/geosearch/pytest
    maps_adv/geosmb/doorman/client/pytest

    maps_adv/geosmb/booking_yang/server
)

CONFTEST_LOAD_POLICY_LOCAL()

PY_SRCS(
    __init__.py
    api/__init__.py
    api/conftest.py
    conftest.py
    clients/__init__.py
    data_manager/__init__.py
    domain/__init__.py
    tasks/__init__.py
    factory.py
    utils.py
)

TEST_SRCS(
    api/test_clear_orders_for_gdpr.py
    api/test_fetch_actual_orders.py
    api/test_list_client_orders.py
    api/test_orders.py
    api/test_ping.py
    api/test_product_sensors.py
    api/test_search_orders_for_gdpr.py
    clients/test_yang_client_create_task_suite.py
    clients/test_yang_client_list_accepted_assignments.py
    data_manager/test_clear_orders_by_passport.py
    data_manager/test_check_orders_existance_by_passport.py
    data_manager/test_create_order.py
    data_manager/test_fetch_actual_orders.py
    data_manager/test_fetch_pending_yang_tasks_count.py
    data_manager/test_iter_created_orders.py
    data_manager/test_iter_orders_notified_to_users.py
    data_manager/test_iter_orders_processed_by_yang.py
    data_manager/test_list_client_orders.py
    data_manager/test_list_orders_for_sending_result_event.py
    data_manager/test_list_orders_without_client.py
    data_manager/test_list_pending_orders.py
    data_manager/test_retrieve_order_by_suite.py
    data_manager/test_retrieve_orders_for_sending_sms.py
    data_manager/test_retrieve_earliest_unprocessed_order_time.py
    data_manager/test_update_orders.py
    domain/test_clear_orders_by_passport.py
    domain/test_create_missed_clients.py
    domain/test_fetch_actual_orders.py
    domain/test_fetch_pending_yang_tasks_count.py
    domain/test_import_processed_tasks.py
    domain/test_list_client_orders.py
    domain/test_make_order.py
    domain/test_notify_about_processed_tasks.py
    domain/test_search_orders_for_gdpr.py
    domain/test_send_missed_result_events.py
    domain/test_time_to_call_calculator.py
    domain/test_upload_orders.py
    tasks/test_created_orders_export_task.py
    tasks/test_orders_processed_by_yang_export_task.py
    tasks/test_orders_notified_to_users_export_task.py
    tasks/test_tasks_warden_integration.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://booking_yang:booking_yang@localhost:5433/booking_yang?master_as_replica=true)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)

END()
