from aiohttp import web
from smb.common.pgswim.lib.engine import SwimEngine

from maps_adv.geosmb.cleaner.server.lib.domain import Domain

from .middlewares import handle_domain_errors, handle_validation_errors
from .resources import Resources

__all__ = ["create"]


def create(db: SwimEngine, domain: Domain) -> web.Application:
    api = web.Application(middlewares=[handle_validation_errors, handle_domain_errors])
    resources = Resources(db, domain)

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.post("/1/takeout/delete/", resources.register_client_for_delete),
            web.get("/1/takeout/status/", resources.retrieve_client_status),
        ]
    )

    return api
