ALTER TABLE delete_requests RENAME COLUMN request_id TO external_id;

CREATE TABLE delete_operations (
    id bigserial PRIMARY KEY,
    request_id bigint NOT NULL REFERENCES delete_requests,
    service_name text NOT NULL,
    is_success boolean NOT NULL,
    metadata jsonb,
    created_at timestamptz NOT NULL DEFAULT now()
);

CREATE INDEX delete_operations_request_id_idx
    ON delete_operations(request_id)
    WHERE is_success IS TRUE;
