save_delete_request = """
    INSERT INTO delete_requests (external_id, passport_uid)
    VALUES ($1, $2)
"""

list_not_processed_records = """
    SELECT id, passport_uid
    FROM delete_requests
    WHERE processed_at IS NULL
    ORDER BY created_at
"""

mark_record_as_processed = """
    UPDATE delete_requests
    SET processed_at = $2
    WHERE id = $1
"""

retrieve_last_request = """
    SELECT id, processed_at
    FROM delete_requests
    WHERE passport_uid = $1
    ORDER BY created_at DESC
    LIMIT 1
"""

retrieve_dt_of_last_processed_request = """
    SELECT processed_at
    FROM delete_requests
    WHERE passport_uid = $1
        AND processed_at IS NOT NULL
    ORDER BY created_at DESC
    LIMIT 1
"""

list_processed_services = """
    SELECT service_name
    FROM delete_operations
    WHERE request_id = $1
        AND is_success IS TRUE
"""


create_operation = """
    INSERT INTO delete_operations (
        request_id,
        service_name,
        metadata,
        is_success
    )
    VALUES ($1, $2, $3, $4)
"""
