PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    smb/common/pgswim/pytest
    smb/common/testing_utils


    maps_adv/common/helpers
    maps_adv/common/lasagna/pytest
    maps_adv/geosmb/doorman/client/pytest

    maps_adv/geosmb/cleaner/server
)

SRCDIR(maps_adv/geosmb/cleaner/server)

PY_SRCS (
    api/__init__.py
    data_manager/__init__.py
    domain/__init__.py
    tasks/__init__.py
    __init__.py
    conftest.py
    factory.py
)

TEST_SRCS(
    api/test_ping.py
    api/test_register_client_for_delete.py
    api/test_retrieve_client_status.py
    data_manager/test_create_operation.py
    data_manager/test_list_processed_services.py
    data_manager/test_list_not_processed_requests.py
    data_manager/test_mark_request_as_processed.py
    data_manager/test_register_client_for_delete.py
    data_manager/test_retrieve_last_request.py
    data_manager/test_retrieve_dt_of_last_processed_request.py
    domain/test_delete_clients.py
    domain/test_register_client_for_delete.py
    domain/test_retrieve_client_status.py
    tasks/test_warden_integration.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://cleaner:cleaner@localhost:5433/cleaner)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()

END()
