from typing import Any

from smb.common.http_client import HttpClient, collect_errors


class BunkerClient(HttpClient):
    def __init__(self, url: str):
        super().__init__(
            url=url,
            ssl=False,
        )

    @collect_errors
    async def get_node_content(self, node: str, version: str = "stable") -> Any:
        response = await self.request(
            method="GET",
            uri="/v1/cat",
            params={"node": node, "version": version},
            expected_statuses=[200],
            metric_name="/v1/cat",
        )

        return response
