import pytest

from maps_adv.geosmb.clients.bunker import BunkerClient


@pytest.fixture(autouse=True)
async def bunker_client(mocker):
    mocker.patch(
        "maps_adv.geosmb.clients.bunker.BunkerClient.get_node_content",
        return_value={"key": "value"},
    )

    async with BunkerClient(url="http://bunker.server") as client:
        yield client
