import pytest

from maps_adv.common.helpers import coro_mock
from maps_adv.geosmb.clients.bvm import BvmClient


@pytest.fixture(autouse=True)
async def bvm(mocker, aiotvm):
    mock = mocker.patch(
        "maps_adv.geosmb.clients.bvm.BvmClient.fetch_biz_id_by_permalink", coro_mock()
    )
    mock.coro.return_value = 15

    mock = mocker.patch(
        "maps_adv.geosmb.clients.bvm.BvmClient.fetch_biz_id_no_create_by_permalink",
        coro_mock(),
    )
    mock.coro.return_value = 15

    mock = mocker.patch(
        "maps_adv.geosmb.clients.bvm.BvmClient.fetch_permalinks_by_biz_id", coro_mock()
    )
    mock.coro.return_value = [54321, 34567]

    mock = mocker.patch(
        "maps_adv.geosmb.clients.bvm.BvmClient.fetch_permalinks_by_biz_ids", coro_mock()
    )
    mock.coro.return_value = {111: [111111], 222: [222222]}

    async with BvmClient(
        "http://bvm.server", tvm=aiotvm, tvm_destination="bvm"
    ) as client:
        yield client
