from unittest.mock import AsyncMock

import pytest

from maps_adv.geosmb.clients.cdp import CdpClient

pytest_plugins = ["smb.common.aiotvm.pytest.plugin"]


@pytest.fixture(autouse=True)
async def cdp(mocker, aiotvm):
    create_contacts_schema = mocker.patch(
        "maps_adv.geosmb.clients.cdp.CdpClient.create_contacts_schema", AsyncMock()
    )
    create_contacts_schema.return_value = None

    create_segment = mocker.patch(
        "maps_adv.geosmb.clients.cdp.CdpClient.create_segment", AsyncMock()
    )
    create_segment.return_value = {
        "counter_id": 60315934,
        "segment_id": 3542,
        "version": 1,
        "name": "TEST",
        "filter": "cdp:cn:multiAttrStr_segments=='two'",
        "segment_type": "REALTIME",
        "size": 15,
    }

    list_segments = mocker.patch(
        "maps_adv.geosmb.clients.cdp.CdpClient.list_segments", AsyncMock()
    )
    list_segments.return_value = [
        {
            "counter_id": 60315934,
            "segment_id": 75,
            "version": 1,
            "name": "GEOSMB_ACTIVE",
            "filter": "cdp:cn:multiAttrStr_segments=='ACTIVE'",
            "segment_type": "REALTIME",
        },
        {
            "counter_id": 60315934,
            "segment_id": 77,
            "version": 1,
            "name": "GEOSMB_DISLOYAL",
            "filter": "cdp:cn:multiAttrStr_segments=='DISLOYAL'",
            "segment_type": "REALTIME",
        },
    ]

    upload_contacts = mocker.patch(
        "maps_adv.geosmb.clients.cdp.CdpClient.upload_contacts", AsyncMock()
    )
    upload_contacts.return_value = None

    get_segment_size = mocker.patch(
        "maps_adv.geosmb.clients.cdp.CdpClient.get_segment_size", AsyncMock()
    )
    get_segment_size.return_value = 100

    async with CdpClient(
        "http://cdp.test", tvm=aiotvm, tvm_destination="cdp"
    ) as client:
        yield client
