import pytest
from smb.common.testing_utils import dt

from maps_adv.common.helpers import AsyncIterator, coro_mock
from maps_adv.geosmb.clients.facade import (
    CouponCoverType,
    CouponDistribution,
    CouponModerationStatus,
    CouponStatus,
    CouponType,
    Currency,
    FacadeIntClient,
    SegmentType,
)


@pytest.fixture(autouse=True)
async def facade(mocker, aiotvm):
    mocker.patch(
        "maps_adv.geosmb.clients.facade.FacadeIntClient.get_organizations_with_coupons",
        AsyncIterator(
            [
                [
                    dict(
                        biz_id="biz_id_0", permalink="1111111111", showcase_url="url_0"
                    ),
                    dict(
                        biz_id="biz_id_1", permalink="2222222222", showcase_url="url_1"
                    ),
                ]
            ]
        ),
    )
    mocker.patch(
        "maps_adv.geosmb.clients.facade.FacadeIntClient.get_organizations_with_booking",
        AsyncIterator(
            [
                [
                    dict(
                        biz_id="biz_id_0", permalink="1111111111", booking_url="url_0"
                    ),
                    dict(
                        biz_id="biz_id_1", permalink="2222222222", booking_url="url_1"
                    ),
                ]
            ]
        ),
    )
    mocker.patch(
        "maps_adv.geosmb.clients.facade.FacadeIntClient.get_loyalty_items_list_for_snapshot",
        AsyncIterator(
            [
                [
                    dict(
                        client_id=111,
                        issued_at=dt("2020-01-01 00:00:00"),
                        id=1,
                        type="COUPON",
                        data={"key1": "value1"},
                    ),
                    dict(
                        client_id=222,
                        issued_at=dt("2020-02-02 00:00:00"),
                        id=2,
                        type="COUPON",
                        data={"key2": "value2"},
                    ),
                ]
            ]
        ),
    )
    mocker.patch(
        "maps_adv.geosmb.clients.facade.FacadeIntClient.get_business_coupons_for_snapshot",
        AsyncIterator(
            [
                [
                    dict(
                        biz_id=1,
                        item_id=11,
                        title="Coupon title 1",
                        services=[
                            dict(
                                service_id="service_id_1",
                                level=1,
                                price=dict(currency=Currency.RUB, cost="100.00"),
                                name="service-kek-1",
                                duration=10,
                            )
                        ],
                        products_description="desc 1",
                        price=dict(currency=Currency.RUB, cost="111.11"),
                        discount=10,
                        discounted_price=dict(currency=Currency.RUB, cost="99.99"),
                        start_date=dt("2020-01-01 01:01:01"),
                        get_until_date=dt("2020-01-02 01:01:01"),
                        end_date=dt("2020-01-03 01:01:01"),
                        distribution=CouponDistribution.PUBLIC,
                        moderation_status=CouponModerationStatus.IN_APPROVED,
                        published=True,
                        payments_enabled=True,
                        conditions="This is conditions 1",
                        creator_login="vas_pup_01",
                        creator_uid="111111",
                        created_at=dt("2019-12-12 01:01:01"),
                        cover_templates=[
                            dict(
                                url_template="http://avatar.yandex.ru/get-smth/abcde/%s",
                                aliases=["alias_x1", "alias_x2"],
                                type=CouponCoverType.DEFAULT,
                            ),
                        ],
                        coupon_showcase_url="https://showcase.yandex/coupon1",
                        meta={"some1": "data1"},
                    )
                ]
            ]
        ),
    )
    mock_list_coupons_statuses = mocker.patch(
        "maps_adv.geosmb.clients.facade.FacadeIntClient.list_coupons_statuses",
        coro_mock(),
    )
    mock_list_coupons_statuses.coro.return_value = [
        dict(biz_id=123, coupon_id=111, status=CouponStatus.RUNNING),
        dict(biz_id=456, coupon_id=222, status=CouponStatus.FINISHED),
    ]
    mocker.patch(
        "maps_adv.geosmb.clients.facade.FacadeIntClient.list_coupons_with_segments",
        AsyncIterator(
            [
                {
                    123: [
                        dict(
                            coupon_id=11,
                            type=CouponType.FREE,
                            segments=[SegmentType.REGULAR, SegmentType.ACTIVE],
                            percent_discount=10,
                        ),
                        dict(
                            coupon_id=22,
                            type=CouponType.SERVICE,
                            segments=[SegmentType.LOST],
                            percent_discount=20,
                        ),
                    ]
                },
                {
                    456: [
                        dict(
                            coupon_id=33,
                            type=CouponType.FREE,
                            segments=[SegmentType.UNPROCESSED_ORDERS],
                            cost_discount="91.99",
                            currency=Currency.RUB,
                        )
                    ]
                },
            ]
        ),
    )
    mocker.patch(
        "maps_adv.geosmb.clients.facade.FacadeIntClient.fetch_coupon_promotions",
        AsyncIterator(
            [
                [
                    dict(
                        advert_id=111,
                        coupon_id=11100,
                        biz_id=1110011,
                        name="Какая-то акция",
                        date_from=dt("2020-03-16 18:00:00"),
                        date_to=dt("2020-04-17 18:00:00"),
                        description="Какое-то описание",
                        announcement="Какой-то анонс",
                        image_url="http://image.url/promo1",
                        coupon_url="http://promotion.url/promo1",
                    ),
                    dict(
                        advert_id=222,
                        coupon_id=22200,
                        name="Какая-то другая акция",
                        date_from=dt("2020-02-16 18:00:00"),
                        date_to=dt("2020-03-17 18:00:00"),
                        description="Какое-то другое описание",
                        announcement="Какой-то другой анонс",
                        image_url="http://image.url/promo2",
                        coupon_url="http://promotion.url/promo2",
                    ),
                ]
            ]
        ),
    )

    async with FacadeIntClient(
        "http://facade.server", tvm=aiotvm, tvm_destination="facade"
    ) as client:
        yield client
