from smb.common.http_client import HttpClient, collect_errors

__all__ = ["GeoBaseClient"]


class GeoBaseClient(HttpClient):
    @collect_errors
    async def fetch_linguistics_for_region(self, geo_id: int) -> dict:
        return await self.request(
            method="GET",
            uri="/v1/linguistics_for_region",
            expected_statuses=[200],
            params={"id": geo_id, "lang": "ru"},
            headers={"Authorization": "maps-adv-clients-landlord"},
            metric_name="/v1/linguistics_for_region"
        )
