import pytest
from smb.common.testing_utils import dt

from maps_adv.common.helpers import coro_mock
from maps_adv.geosmb.clients.market import (
    ClientAction,
    MarketIntClient,
    PriceType,
    ServiceStatus,
)


@pytest.fixture(autouse=True)
async def market_int(mocker, config):
    fetch_services = mocker.patch(
        "maps_adv.geosmb.clients.market.MarketIntClient.fetch_services", coro_mock()
    )
    fetch_services.coro.return_value = services_seq

    fetch_service_categories = mocker.patch(
        "maps_adv.geosmb.clients.market.MarketIntClient.fetch_service_categories",
        coro_mock(),
    )
    fetch_service_categories.coro.return_value = {
        1200: "Классно выйдет",
        1300: "Вообще топовая услуга",
        1400: "Популярное",
        1500: "Ещё категория для красоты",
    }

    fetch_actual_orders = mocker.patch(
        "maps_adv.geosmb.clients.market.MarketIntClient.fetch_actual_orders",
        coro_mock(),
    )
    fetch_actual_orders.coro.return_value = [
        {
            "client_id": 11,
            "biz_id": 111,
            "reservation_datetime": dt("2019-12-25 11:00:00"),
        },
    ]

    async with MarketIntClient(config["MARKET_INT_URL"]) as client:
        yield client


services_seq = [
    dict(
        item_id=200,
        biz_id=22,
        name="Стрижка",
        status=ServiceStatus.PUBLISHED,
        category_ids=[1200, 1300],
        min_price=dict(value="15.99", currency="RUB"),
        duration_minutes=60,
        main_image_url_template="https://strizhka.url/pic",
        updated_at="2020-08-20T16:30:00",
        description="Подстрижём под горшок профессионально",
        price_type=PriceType.UNKNOWN,
        client_action=ClientAction.LINK,
        client_action_settings=dict(
            link=dict(
                link="https://ya.ru",
                button_text="ссылка"
            )
        ),
        service_prices=[
            dict(
                service_id=20,
                price=dict(value="25.99", currency="RUB"),
                duration_minutes=45,
                schedule=dict(schedule_id=12),
            ),
            dict(
                service_id=30,
                price=dict(value="26.99", currency="RUB"),
                duration_minutes=30,
                schedule=dict(schedule_id=12),
            ),
        ],
    ),
    dict(
        item_id=300,
        biz_id=22,
        name="Стрижка собаки",
        status=ServiceStatus.PUBLISHED,
        category_ids=[1300, 1400],
        duration_minutes=15,
        updated_at="2020-08-20T16:30:00",
        description="Ты чо пёс?",
        price_type=PriceType.UNKNOWN,
        service_prices=[],
    ),
    dict(
        item_id=400,
        biz_id=22,
        name="Стрижка кота",
        status=ServiceStatus.PUBLISHED,
        category_ids=[1400, 1200],
        min_price=dict(value="100.99", currency="RUB"),
        duration_minutes=45,
        updated_at="2020-08-20T16:30:00",
        price_type=PriceType.UNKNOWN,
        service_prices=[
            dict(
                service_id=50,
                price=dict(value="25.99", currency="RUB"),
                schedule=dict(schedule_id=12),
            ),
        ],
    ),
]
