from typing import Any

from smb.common.http_client import HttpClient, collect_errors


class NotifyMeClient(HttpClient):
    def __init__(self, url: str):
        super().__init__(
            url=url,
            ssl=False,
        )

    @collect_errors
    async def send_message(self, telegram_uid: str, text: str) -> Any:
        response = await self.request(
            method="POST",
            uri="/api/send-message",
            json={"user_id": telegram_uid, "message": text},
            expected_statuses=[200],
        )

        return response
