import pytest

from maps_adv.geosmb.clients.notify_me import NotifyMeClient


@pytest.fixture(autouse=True)
async def bunker_client(mocker):
    mocker.patch(
        "maps_adv.geosmb.clients.notify_me.NotifyMeClient.send_message",
        return_value={"key": "value"},
    )

    async with NotifyMeClient(url="http://notify_me_test.server") as client:
        yield client
