import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.crane_operator.server.lib import Application

config = ConfigLoader(
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_SELF_ALIAS", default="self"),
    Option("WARDEN_URL"),
    Option("FACADE_URL"),
    Option("LOYALTY_URL"),
    Option("BOOKING_YANG_URL"),
    Option("DOORMAN_URL"),
    Option("MARKET_INT_URL"),
    Option("GEOSEARCH_URL"),
    Option("BVM_URL"),
    Option("YT_CLUSTER", default="hahn"),
    Option("YT_TOKEN"),
    Option("YQL_TOKEN"),
    Option("YT_TABLE_FOR_SNIPPET", default=None),
    Option("YT_TABLE_FOR_ORDERS_POI", default=None),
    Option("YT_TABLE_FOR_COUPONS_POI", default=None),
    Option("YT_TABLE_CLIENTS", default=None),
    Option("YT_TABLE_GEOADV_CAMPAIGNS", default=None),
    Option("YT_TABLE_GEOADV_CAMPAIGN_ORGS", default=None),
    Option("BOOKING_YANG_ORDERS_POI_EXPERIMENT", default=""),
    Option("MARKET_INT_ORDERS_POI_EXPERIMENT", default=""),
    Option("COUPONS_POI_EXPERIMENT_TAG", default=""),
    Option("ORGS_WITH_BOOKING_YT_EXPORT_TABLE", default=None),
    Option("ORGS_WITH_COUPONS_YT_EXPORT_TABLE", default=None),
    Option("COUPON_PROMOTIONS_YT_EXPORT_TABLE", default=None),
    Option("LOYALTY_ITEMS_YT_EXPORT_TABLE", default=None),
    Option("BUSINESS_COUPONS_YT_EXPORT_TABLE", default=None),
    Option("COUPONS_WITH_SEGMENTS_YT_EXPORT_TABLE", default=None),
    Option("YT_REPLICATION_CLUSTER", default="arnold"),
    Option("WARDEN_TASKS", default=(), converter=converters.Tuple()),
    Option("LOGBROKER_WRITER_HOST"),
    Option("LOGBROKER_MESSAGE_COUNT_THRESHOLD", default=100),
    Option(
        "LOGBROKER_READER_HOSTS",
        converter=lambda data: [el.strip() for el in data.split(",")],
    ),
    Option("LOGBROKER_PORT"),
    Option(
        "LOGBROKER_DEFAULT_SOURCE_ID",
        default=b"CraneOperatorDefaultSourceId",
        converter=lambda data: data.encode(),
    ),
    Option("LOGBROKER_COUPONS_TO_REVIEW_TOPIC_OUT"),
    Option("LOGBROKER_COUPONS_REVIEWED_TOPIC_IN"),
    Option("LOGBROKER_CONSUMER_ID"),
)

arg_parser = argparse.ArgumentParser("Cleaner")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
