PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    smb/common/testing_utils

    maps_adv/common/lasagna/pytest
    maps_adv/common/shared_mock/pytest
    maps_adv/geosmb/booking_yang/client/pytest
    maps_adv/geosmb/doorman/client/pytest
    maps_adv/geosmb/clients/bvm/pytest
    maps_adv/geosmb/clients/facade/pytest
    maps_adv/geosmb/clients/geosearch/pytest
    maps_adv/geosmb/clients/market/pytest

    maps_adv/geosmb/crane_operator/server
)

SRCDIR(maps_adv/geosmb/crane_operator)

PY_SRCS(
    __init__.py
    api/__init__.py
    domains/__init__.py
    domains/coupons_domain/__init__.py
    domains/coupons_domain/conftest.py
    domains/poi_domain/__init__.py
    domains/poi_domain/conftest.py
    tasks/__init__.py
    tasks/conftest.py
    shared_mock.py
    conftest.py
    utils.py
)

CONFTEST_LOAD_POLICY_LOCAL()

TEST_SRCS(
    api/test_ping.py
    domains/poi_domain/test_iter_orders_from_all_sources.py
    domains/poi_domain/test_iter_orders_from_booking_yang.py
    domains/poi_domain/test_iter_orders_from_market.py
    domains/coupons_domain/test_export_coupons_for_review.py
    domains/coupons_domain/test_export_coupons_reviewed_to_loyalty.py
    domains/coupons_domain/test_iter_business_coupons_for_export.py
    domains/coupons_domain/test_iter_coupons_with_segments_for_export.py
    domains/coupons_domain/test_iter_loyalty_items_for_export.py
    domains/coupons_domain/test_iter_coupon_promotions_for_export.py
    domains/coupons_domain/test_iter_organizations_with_coupons_for_export.py
    domains/coupons_domain/test_iter_organizations_with_booking_for_export.py
    tasks/test_export_business_coupons.py
    tasks/test_export_coupon_promotions.py
    tasks/test_export_coupons_with_segments.py
    tasks/test_export_loyalty_items.py
    tasks/test_export_orders_poi_data.py
    tasks/test_export_organizations_with_booking.py
    tasks/test_export_organizations_with_coupons.py
    tasks/test_generate_coupons_poi_data.py
    tasks/test_generate_data_for_snippet.py
    tasks/test_tasks_warden_integration.py
)

END()
