from enum import Enum, auto, unique

from maps_adv.geosmb.doorman.proto.common_pb2 import (
    ClientGender as ClientGenderPb,
    Source as SourcePb,
)
from maps_adv.geosmb.doorman.proto.events_pb2 import (
    CallEvent as CallEventPb,
    OrderEventType as OrderEventTypePb,
)
from maps_adv.geosmb.doorman.proto.segments_pb2 import SegmentType as SegmentTypePb


@unique
class Source(Enum):
    CRM_INTERFACE = auto()
    BOOKING_YANG = auto()
    GEOADV_PHONE_CALL = auto()
    LOYALTY_COUPONS = auto()
    BOOKING_WIDGET = auto()
    BOOKING_REQUEST = auto()


@unique
class CallEvent(Enum):
    INITIATED = auto()
    FINISHED = auto()


@unique
class ClientGender(Enum):
    MALE = auto()
    FEMALE = auto()


@unique
class SegmentType(Enum):
    REGULAR = "regular"
    ACTIVE = "active"
    LOST = "lost"
    UNPROCESSED_ORDERS = "unprocessed_orders"
    NO_ORDERS = "no_orders"
    MISSED_LAST_CALL = "missed_last_call"
    SHORT_LAST_CALL = "short_last_call"


@unique
class OrderEvent(Enum):
    CREATED = auto()
    REJECTED = auto()
    ACCEPTED = auto()


ENUM_TO_PROTO_MAP = {
    "source": {
        Source.CRM_INTERFACE: SourcePb.CRM_INTERFACE,
        Source.BOOKING_YANG: SourcePb.BOOKING_YANG,
        Source.GEOADV_PHONE_CALL: SourcePb.GEOADV_PHONE_CALL,
        Source.LOYALTY_COUPONS: SourcePb.LOYALTY_COUPONS,
        Source.BOOKING_WIDGET: SourcePb.BOOKING_WIDGET,
        Source.BOOKING_REQUEST: SourcePb.BOOKING_REQUEST
    },
    "gender": {
        ClientGender.MALE: ClientGenderPb.MALE,
        ClientGender.FEMALE: ClientGenderPb.FEMALE,
    },
    "segment_type": {
        SegmentType.REGULAR: SegmentTypePb.REGULAR,
        SegmentType.ACTIVE: SegmentTypePb.ACTIVE,
        SegmentType.LOST: SegmentTypePb.LOST,
        SegmentType.UNPROCESSED_ORDERS: SegmentTypePb.UNPROCESSED_ORDERS,
        SegmentType.NO_ORDERS: SegmentTypePb.NO_ORDERS,
        SegmentType.MISSED_LAST_CALL: SegmentTypePb.MISSED_LAST_CALL,
        SegmentType.SHORT_LAST_CALL: SegmentTypePb.SHORT_LAST_CALL,
    },
    "order_event_type": {
        OrderEvent.CREATED: OrderEventTypePb.CREATED,
        OrderEvent.REJECTED: OrderEventTypePb.REJECTED,
        OrderEvent.ACCEPTED: OrderEventTypePb.ACCEPTED,
    },
    "call_event_type": {
        CallEvent.INITIATED: CallEventPb.INITIATED,
        CallEvent.FINISHED: CallEventPb.FINISHED,
    },
}

PROTO_TO_ENUM_MAP = {
    "source": [
        (SourcePb.CRM_INTERFACE, Source.CRM_INTERFACE),
        (SourcePb.BOOKING_YANG, Source.BOOKING_YANG),
        (SourcePb.GEOADV_PHONE_CALL, Source.GEOADV_PHONE_CALL),
        (SourcePb.LOYALTY_COUPONS, Source.LOYALTY_COUPONS),
        (SourcePb.BOOKING_WIDGET, Source.BOOKING_WIDGET),
        (SourcePb.BOOKING_REQUEST, Source.BOOKING_REQUEST)
    ],
    "gender": [
        (ClientGenderPb.MALE, ClientGender.MALE),
        (ClientGenderPb.FEMALE, ClientGender.FEMALE),
    ],
    "segment_type": [
        (SegmentTypePb.REGULAR, SegmentType.REGULAR),
        (SegmentTypePb.ACTIVE, SegmentType.ACTIVE),
        (SegmentTypePb.LOST, SegmentType.LOST),
        (SegmentTypePb.UNPROCESSED_ORDERS, SegmentType.UNPROCESSED_ORDERS),
        (SegmentTypePb.NO_ORDERS, SegmentType.NO_ORDERS),
        (SegmentTypePb.MISSED_LAST_CALL, SegmentType.MISSED_LAST_CALL),
        (SegmentTypePb.SHORT_LAST_CALL, SegmentType.SHORT_LAST_CALL),
    ],
    "order_event_type": [
        (OrderEventTypePb.CREATED, OrderEvent.CREATED),
        (OrderEventTypePb.REJECTED, OrderEvent.REJECTED),
        (OrderEventTypePb.ACCEPTED, OrderEvent.ACCEPTED),
    ],
    "call_event_type": [
        (CallEventPb.INITIATED, CallEvent.INITIATED),
        (CallEventPb.FINISHED, CallEvent.FINISHED),
    ],
}
