import pytest
from smb.common.testing_utils import dt

from maps_adv.common.helpers import coro_mock
from maps_adv.geosmb.doorman.client import DoormanClient
from maps_adv.geosmb.doorman.client.lib.enums import ClientGender, SegmentType, Source


@pytest.fixture(autouse=True)
async def doorman(mocker, aiotvm, config):
    create_client_mock = mocker.patch(
        "maps_adv.geosmb.doorman.client.DoormanClient.create_client", coro_mock()
    )
    create_client_mock.coro.return_value = dict(id=100500)

    create_clients_mock = mocker.patch(
        "maps_adv.geosmb.doorman.client.DoormanClient.create_clients", coro_mock()
    )
    create_clients_mock.coro.return_value = (1, 2)

    add_order_event = mocker.patch(
        "maps_adv.geosmb.doorman.client.DoormanClient.add_order_event", coro_mock()
    )
    add_order_event.coro.return_value = None

    retrieve_client_mock = mocker.patch(
        "maps_adv.geosmb.doorman.client.DoormanClient.retrieve_client", coro_mock()
    )
    retrieve_client_mock.coro.return_value = {
        "id": 111,
        "biz_id": 123,
        "phone": 1234567890123,
        "email": "email@yandex.ru",
        "passport_uid": 456,
        "first_name": "client_first_name",
        "last_name": "client_last_name",
        "gender": ClientGender.MALE,
        "comment": "this is comment",
        "labels": "orange",
        "segments": [SegmentType.REGULAR, SegmentType.ACTIVE],
        "statistics": {
            "orders": {
                "total": 3,
                "successful": 1,
                "unsuccessful": 2,
                "last_order_timestamp": dt("2020-03-03 00:00:00"),
            }
        },
        "source": Source.CRM_INTERFACE,
        "registration_timestamp": dt("2020-01-01 13:10:20"),
    }

    list_contacts_mock = mocker.patch(
        "maps_adv.geosmb.doorman.client.lib.client.DoormanClient.list_contacts",
        coro_mock(),
    )
    list_contacts_mock.coro.return_value = {
        111: dict(
            biz_id=123,
            phone=1234567890123,
            email="email@yandex.ru",
            passport_uid=456,
            first_name="client_first_name",
            last_name="client_last_name",
            cleared_for_gdpr=False,
        )
    }

    clear_clients_for_gdpr = mocker.patch(
        "maps_adv.geosmb.doorman.client.lib.client.DoormanClient.clear_clients_for_gdpr",  # noqa
        coro_mock(),
    )
    clear_clients_for_gdpr.coro.return_value = [{"client_id": 111, "biz_id": 456}]

    search_clients_for_gdpr_mock = mocker.patch(
        "maps_adv.geosmb.doorman.client.lib.client.DoormanClient.search_clients_for_gdpr",  # noqa
        coro_mock(),
    )
    search_clients_for_gdpr_mock.coro.return_value = True

    async with DoormanClient(
        url=config["DOORMAN_URL"], tvm=aiotvm, tvm_destination="doorman"
    ) as client:
        yield client
