from aiohttp import web

from maps_adv.geosmb.doorman.server.lib.domain import Domain

from .middlewares import (
    handle_authentication_errors,
    handle_domain_errors,
    handle_validation_errors,
)
from .providers import ApiProvider
from .resources import Resources

__all__ = ["create", "ApiProvider"]


def create(domain: Domain) -> web.Application:
    api = web.Application(
        middlewares=[
            handle_validation_errors,
            handle_domain_errors,
            handle_authentication_errors,
        ]
    )

    resources = Resources(ApiProvider(domain))

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.post("/v1/create_client/", resources.create_client),
            web.post("/v1/create_clients/", resources.create_clients),
            web.post("/v1/retrieve_client/", resources.retrieve_client),
            web.post("/v1/list_clients/", resources.list_clients),
            web.post("/v1/list_contacts/", resources.list_contacts),
            web.post("/v1/list_suggest_clients/", resources.list_suggest_clients),
            web.post("/v1/update_client/", resources.update_client),
            web.post("/v1/list_segments/", resources.list_segments),
            web.post("/v1/segment_statistics/", resources.segment_statistics),
            web.post("/v1/list_clients_by_segment/", resources.list_clients_by_segment),
            web.post("/v1/add_event/", resources.add_event),
            web.post("/v1/list_client_segments/", resources.list_client_segments),
            web.post("/v1/list_client_events/", resources.list_client_events),
            web.post(
                "/internal/v1/clear_clients_for_gdpr/", resources.clear_clients_for_gdpr
            ),
            web.post(
                "/internal/v1/search_clients_for_gdpr/",
                resources.search_clients_for_gdpr,
            ),
        ]
    )

    return api
