from aiohttp.web import Request, Response

from maps_adv.common.lasagna import tvm_auth

from .providers import ApiProvider


class Resources:
    __slots__ = ("_provider", "_tvm_client", "_tvm_whitelist")

    _provider: ApiProvider

    def __init__(self, provider: ApiProvider):
        self._provider = provider

    async def ping(self, _: Request) -> Response:
        return Response(status=204)

    async def create_client(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.create_client(data=body)

        return Response(status=201, body=result)

    async def create_clients(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.create_clients(data=body)

        return Response(status=201, body=result)

    async def retrieve_client(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.retrieve_client(data=body)

        return Response(status=200, body=result)

    async def list_clients(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_clients(data=body)

        return Response(status=200, body=result)

    async def list_contacts(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_contacts(data=body)

        return Response(status=200, body=result)

    async def list_suggest_clients(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_suggest_clients(data=body)

        return Response(status=200, body=result)

    async def update_client(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.update_client(data=body)

        return Response(status=200, body=result)

    async def list_segments(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.list_segments(data=body)
        return Response(status=200, body=result)

    async def segment_statistics(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.segment_statistics(data=body)
        return Response(status=200, body=result)

    async def list_clients_by_segment(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.list_clients_by_segment(data=body)
        return Response(status=200, body=result)

    async def add_event(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.add_event(data=body)

        return Response(status=201, body=result)

    async def list_client_segments(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_client_segments(data=body)

        return Response(status=200, body=result)

    async def list_client_events(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_client_events(data=body)

        return Response(status=200, body=result)

    @tvm_auth.only("TVM_GDPR_WHITELIST")
    async def clear_clients_for_gdpr(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.clear_clients_for_gdpr(data=body)

        return Response(status=200, body=result)

    @tvm_auth.only("TVM_GDPR_WHITELIST")
    async def search_clients_for_gdpr(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.search_clients_for_gdpr(data=body)

        return Response(status=200, body=result)
