DELETE FROM search_tokens;

INSERT INTO search_tokens (token)
SELECT parse_tokens(first_name) from clients
UNION
SELECT parse_tokens(last_name) from clients
UNION
SELECT email from clients WHERE email IS NOT NULL
UNION
SELECT parse_tokens(comment) from clients
;


CREATE OR REPLACE FUNCTION add_search_tokens()
RETURNS trigger AS $$
    BEGIN
        INSERT INTO search_tokens (token)
        SELECT * FROM parse_tokens(NEW.first_name)
        UNION
        SELECT * FROM parse_tokens(NEW.last_name)
        UNION
        SELECT NEW.email WHERE NEW.email IS NOT NULL
        UNION
        SELECT * FROM parse_tokens(NEW.comment)
        ON CONFLICT DO nothing;
        RETURN NEW;
    END
$$ LANGUAGE 'plpgsql';
