from enum import Enum, auto, unique


@unique
class Source(Enum):
    CRM_INTERFACE = "CRM_INTERFACE"
    BOOKING_YANG = "BOOKING_YANG"
    GEOADV_PHONE_CALL = "GEOADV_PHONE_CALL"
    LOYALTY_COUPONS = "LOYALTY_COUPONS"
    BOOKING_WIDGET = "BOOKING_WIDGET"
    BOOKING_REQUEST = "BOOKING_REQUEST"


@unique
class ClientGender(Enum):
    MALE = auto()
    FEMALE = auto()


@unique
class SegmentType(Enum):
    REGULAR = "REGULAR"
    ACTIVE = "ACTIVE"
    LOST = "LOST"
    UNPROCESSED_ORDERS = "UNPROCESSED_ORDERS"
    NO_ORDERS = "NO_ORDERS"
    SHORT_LAST_CALL = "SHORT_LAST_CALL"
    MISSED_LAST_CALL = "MISSED_LAST_CALL"


@unique
class OrderByField(Enum):
    PHONE = "phone"
    EMAIL = "email"
    FIRST_AND_LAST_NAME = auto()
    COMMENT = "comment"
    STAT_ORDERS_TOTAL = "stat_order_total"
    STAT_ORDERS_SUCCESSFUL = "stat_order_successful"
    STAT_ORDERS_UNSUCCESSFUL = "stat_order_unsuccessful"
    STAT_ORDERS_LAST_ORDER_TS = "stat_order_last_created_ts"


@unique
class OrderDirection(Enum):
    ASC = auto()
    DESC = auto()


@unique
class OrderEvent(Enum):
    CREATED = auto()
    REJECTED = auto()
    ACCEPTED = auto()


@unique
class CallEvent(Enum):
    INITIATED = auto()
    FINISHED = auto()


@unique
class CallHistoryEvent(Enum):
    INITIATED = auto()
    ACCEPTED = auto()
    MISSED = auto()
