class DoormanException(Exception):
    pass


class UnknownClient(DoormanException):
    __slots__ = ["search_fields"]

    search_fields: dict

    def __init__(self, **kwargs):
        self.search_fields = kwargs.copy()
        super().__init__()


class BadClientData(DoormanException):
    pass


class ClientAlreadyExists(DoormanException):
    pass


class NoTvmTicket(DoormanException):
    pass


class TvmForbidden(DoormanException):
    pass


class UnsupportedEventType(DoormanException):
    pass


class InvalidEventParams(DoormanException):
    pass


class NoClientIdFieldsPassed(DoormanException):
    pass


class AttemptToUpdateClearedClient(DoormanException):
    pass
