add_order_event = """
    INSERT INTO order_events (
        client_id,
        biz_id,
        order_id,
        event_type,
        event_timestamp,
        source
    )
    VALUES ($1, $2, $3, $4, $5, $6)
"""

add_call_event = """
    INSERT INTO call_events (
        client_id,
        biz_id,
        event_type,
        event_value,
        event_timestamp,
        source,
        session_id
    )
    VALUES ($1, $2, $3, $4, $5, $6, $7)
"""

fetch_last_call_event_geoproduct_id = """
    SELECT MAX(geoproduct_id)
    FROM call_events
"""

list_call_events = """
    WITH client_events AS (
        SELECT *
        FROM call_events
        WHERE client_id = $1
            AND biz_id = $2
    ),
    pending_init_events AS (
        SELECT init_event.source, init_event.event_timestamp
        FROM client_events AS init_event
        LEFT JOIN client_events AS finished_event
            ON finished_event.session_id = init_event.session_id
            AND finished_event.event_type = 'FINISHED'
        WHERE init_event.event_type = 'INITIATED'
            AND finished_event.id IS NULL
    ),
    accepted_call_events AS (
        SELECT source, event_timestamp, talk_duration, await_duration
        FROM client_events
        WHERE event_type = 'FINISHED'
            AND talk_duration > 0
    ),
    missed_call_events AS (
        SELECT source, event_timestamp, talk_duration, await_duration
        FROM client_events
        WHERE event_type = 'FINISHED'
            AND talk_duration = 0
    ),
    full_history AS (
        SELECT
            source,
            event_timestamp,
            'INITIATED' AS history_type,
            NULL AS talk_duration,
            NULL AS await_duration
        FROM pending_init_events

        UNION ALL

        SELECT
            source,
            event_timestamp,
            'ACCEPTED' AS history_type,
            talk_duration,
            await_duration
        FROM accepted_call_events

        UNION ALL

        SELECT
            source,
            event_timestamp,
            'MISSED' AS history_type,
            talk_duration,
            await_duration
        FROM missed_call_events
    ),
    events_in_interval AS (
        SELECT *
        FROM full_history
        WHERE TRUE
        {interval_conditions}
    ),
    events_beyond_interval_counts AS (
        SELECT COUNT(*) FILTER (WHERE event_timestamp < $3) AS events_before,
            COUNT(*) FILTER (WHERE event_timestamp > $4) AS events_after
        FROM client_events
    )
    SELECT ei.*, ec.*
    FROM events_in_interval AS ei
    RIGHT JOIN events_beyond_interval_counts AS ec ON TRUE
    ORDER BY ei.event_timestamp DESC
"""

create_table_import_call_events_tmp = """
    DROP TABLE IF EXISTS import_call_events_tmp;

    CREATE TABLE import_call_events_tmp (
        geoproduct_id int8 NOT NULL,
        permalink int8 NOT NULL,
        client_phone varchar(16) NOT NULL,
        event_timestamp timestamptz NOT NULL,
        await_duration smallint,
        talk_duration smallint,
        event_value varchar(512),
        session_id int8,
        record_url text
    );
"""

create_table_call_event_clients_tmp = """
    CREATE TEMPORARY TABLE call_event_clients_tmp (
        permalink int8 NOT NULL,
        biz_id int8 NOT NULL,
        client_id int8 NOT NULL,
        client_phone varchar(16) NOT NULL
    )
    ON COMMIT DROP;
"""

upload_imported_call_events = """
    INSERT INTO call_events (
        client_id,
        biz_id,
        event_type,
        event_value,
        event_timestamp,
        source,
        session_id,
        record_url,
        await_duration,
        talk_duration,
        geoproduct_id
    )
    SELECT
        _clients.client_id,
        _clients.biz_id,
        $1,
        _events.event_value,
        _events.event_timestamp,
        $2,
        _events.session_id,
        _events.record_url,
        _events.await_duration,
        _events.talk_duration,
        _events.geoproduct_id
    FROM import_call_events_tmp AS _events
    JOIN call_event_clients_tmp AS _clients ON
        _clients.permalink = _events.permalink
        AND _clients.client_phone = _events.client_phone
"""
