PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    contrib/python/pytest-freezegun

    smb/common/pgswim/pytest
    smb/common/testing_utils

    maps_adv/common/shared_mock/pytest
    maps_adv/common/lasagna/pytest
    maps_adv/geosmb/clients/bvm/pytest
    maps_adv/geosmb/doorman/server
)

SRCDIR(maps_adv/geosmb/doorman/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/create_client/__init__.py
    api/list_clients/__init__.py
    api/list_segments/__init__.py
    api/list_segments/utils.py
    api/retrieve_client/__init__.py
    api/segment_statistics/__init__.py
    conftest.py
    data_managers/__init__.py
    data_managers/create_clients/__init__.py
    data_managers/list_clients/__init__.py
    data_managers/list_segments/__init__.py
    data_managers/retrieve_client/__init__.py
    data_managers/segment_statistics/__init__.py
    domain/__init__.py
    factory.py
    sensors/__init__.py
    shared_mock.py
    tasks/__init__.py
    utils.py
)

TEST_SRCS(
    api/create_client/test_create_client.py
    api/create_client/test_merge_client.py
    api/list_clients/test_filter_by_ids.py
    api/list_clients/test_filter_by_label.py
    api/list_clients/test_filter_by_segment.py
    api/list_clients/test_list.py
    api/list_clients/test_pagination.py
    api/list_clients/test_search.py
    api/list_clients/test_sorting.py
    api/list_segments/test_active_segment.py
    api/list_segments/test_all_segments.py
    api/list_segments/test_lost_segment.py
    api/list_segments/test_missed_last_call_segment.py
    api/list_segments/test_no_orders_segment.py
    api/list_segments/test_regular_segment.py
    api/list_segments/test_short_last_call_segment.py
    api/list_segments/test_unprocessed_orders_segment.py
    api/retrieve_client/test_retrieve_client.py
    api/retrieve_client/test_segmentation.py
    api/segment_statistics/test_active.py
    api/segment_statistics/test_all.py
    api/segment_statistics/test_lost.py
    api/segment_statistics/test_missed_last_call.py
    api/segment_statistics/test_no_orders.py
    api/segment_statistics/test_regular.py
    api/segment_statistics/test_segment_statistics.py
    api/segment_statistics/test_short_last_call.py
    api/segment_statistics/test_unprocessed_orders.py
    api/test_add_event.py
    api/test_clear_clients_for_gdpr.py
    api/test_create_clients.py
    api/test_list_client_events.py
    api/test_list_client_segments.py
    api/test_list_clients_by_segment.py
    api/test_list_contacts.py
    api/test_list_suggest_clients.py
    api/test_ping.py
    api/test_search_clients_for_gdpr.py
    api/test_update_client.py
    data_managers/create_clients/test_create_clients.py
    data_managers/create_clients/test_merge_input_data.py
    data_managers/create_clients/test_merge_with_existed.py
    data_managers/list_clients/test_filter_by_ids.py
    data_managers/list_clients/test_filter_by_label.py
    data_managers/list_clients/test_filter_by_segment.py
    data_managers/list_clients/test_list.py
    data_managers/list_clients/test_pagination.py
    data_managers/list_clients/test_search.py
    data_managers/list_clients/test_sorting.py
    data_managers/list_segments/test_active_segment.py
    data_managers/list_segments/test_all_segments.py
    data_managers/list_segments/test_lost_segment.py
    data_managers/list_segments/test_missed_last_call_segment.py
    data_managers/list_segments/test_no_orders_segment.py
    data_managers/list_segments/test_regular_segment.py
    data_managers/list_segments/test_short_last_call_segment.py
    data_managers/list_segments/test_unprocessed_orders_segment.py
    data_managers/retrieve_client/test_retrieve_client.py
    data_managers/retrieve_client/test_segmentation.py
    data_managers/segment_statistics/test_active.py
    data_managers/segment_statistics/test_all.py
    data_managers/segment_statistics/test_lost.py
    data_managers/segment_statistics/test_missed_last_call.py
    data_managers/segment_statistics/test_no_orders.py
    data_managers/segment_statistics/test_regular.py
    data_managers/segment_statistics/test_short_last_call.py
    data_managers/segment_statistics/test_unprocessed_orders.py
    data_managers/test_add_call_event.py
    data_managers/test_add_order_event.py
    data_managers/test_check_clients_existance_by_passport.py
    data_managers/test_clear_clients_by_passport.py
    data_managers/test_client_exists.py
    data_managers/test_create_client.py
    data_managers/test_create_table_import_call_events_tmp.py
    data_managers/test_fetch_max_geoproduct_id_for_call_events.py
    data_managers/test_find_client.py
    data_managers/test_iter_clients_for_export.py
    data_managers/test_list_client_events.py
    data_managers/test_list_client_segments.py
    data_managers/test_list_clients_by_label.py
    data_managers/test_list_clients_by_segment.py
    data_managers/test_list_contacts.py
    data_managers/test_list_suggest_clients.py
    data_managers/test_merge_client.py
    data_managers/test_store_imported_call_events.py
    data_managers/test_update_client.py
    data_managers/test_upload_imported_call_events.py
    domain/test_add_event.py
    domain/test_clear_clients_for_gdpr.py
    domain/test_create_client.py
    domain/test_create_clients.py
    domain/test_import_call_events.py
    domain/test_list_client_events.py
    domain/test_list_client_segments.py
    domain/test_list_clients.py
    domain/test_list_clients_by_segment.py
    domain/test_list_contacts.py
    domain/test_list_segments.py
    domain/test_list_suggest_clients.py
    domain/test_retrieve_client.py
    domain/test_search_clients_for_gdpr.py
    domain/test_segment_statistics.py
    domain/test_update_client.py
    sensors/test_empty_clients_search.py
    tasks/test_call_events_yt_import.py
    tasks/test_clients_yt_export.py
    tasks/test_tasks_warden_integration.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://doorman:doorman@localhost:5433/doorman?master_as_replica=true)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

END()
