PY3_LIBRARY()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/dateutil
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2
    contrib/python/pytz
    contrib/python/sqlalchemy/sqlalchemy-1.2

    smb/common/multiruntime
    smb/common/pgswim

    maps_adv/common/config_loader
    smb/common/aiotvm
    maps_adv/common/helpers
    maps_adv/common/lasagna
    maps_adv/common/protomallow
    maps_adv/common/yt_utils
    maps_adv/geosmb/clients/bvm
    maps_adv/warden/client

    maps_adv/geosmb/doorman/proto
)

PY_SRCS(
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers.py
    lib/api/resources.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/sqls/__init__.py
    lib/sqls/base.py
    lib/sqls/clients.py
    lib/sqls/bulk_clients.py
    lib/sqls/events.py
    lib/sqls/list_clients.py
    lib/sqls/segments.py
    lib/__init__.py
    lib/data_managers.py
    lib/domain.py
    lib/enums.py
    lib/exceptions.py
    lib/tasks/__init__.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/doorman/
    lib/db/migrations/001_20201211/upgrade.sql
    lib/db/migrations/001_20201211/downgrade.sql
    lib/db/migrations/002_20201217/upgrade.sql
    lib/db/migrations/002_20201217/downgrade.sql
    lib/db/migrations/003_20210114/upgrade.sql
    lib/db/migrations/003_20210114/downgrade.sql
    lib/db/migrations/004_20210118/upgrade.sql
    lib/db/migrations/004_20210118/downgrade.sql
    lib/db/migrations/005_20210122/upgrade.sql
    lib/db/migrations/005_20210122/downgrade.sql
    lib/db/migrations/006_20210205/upgrade.sql
    lib/db/migrations/006_20210205/downgrade.sql
    lib/db/migrations/007_20210224/upgrade.sql
    lib/db/migrations/007_20210224/downgrade.sql
    lib/db/migrations/008_20210309/upgrade.sql
    lib/db/migrations/008_20210309/downgrade.sql
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
