from aiohttp.web import Application, Request, Response, get, post


async def ping(_: Request) -> Response:
    return Response(status=200)


async def echo(req: Request) -> Response:
    body = await req.read()
    return Response(body=body)


async def error(_: Request) -> Response:
    raise Exception("LOL KEK MAKAREK")


def make_api() -> Application:
    api = Application()
    api.add_routes(
        [
            get("/ping", ping),
            post("/echo/", echo),
            get("/echo/", echo),
            get("/error/", error),
        ]
    )
    return api
