PY3_LIBRARY()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/aioredis/aioredis-1
    contrib/python/aioredis-lock
    contrib/python/motor
    contrib/python/openpyxl

    smb/common/multiruntime
    maps_adv/common/config_loader
    maps_adv/common/lasagna
    maps_adv/common/mds
    maps_adv/geosmb/doorman/client
    maps_adv/geosmb/harmonist/proto
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers.py
    lib/api/resources.py
    lib/data_manager.py
    lib/domain/__init__.py
    lib/domain/file_parsers.py
    lib/domain/lock_manager.py
    lib/domain/validator.py
    lib/enums.py
    lib/exceptions.py
    lib/engine.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/harmonist/server
)


END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
