from aiohttp import web

from maps_adv.geosmb.harmonist.server.lib.domain import Domain

from .middlewares import handle_domain_errors, handle_validation_errors
from .providers import ApiProvider
from .resources import Resources

__all__ = ["create"]


def create(domain: Domain) -> web.Application:
    api = web.Application(middlewares=[handle_validation_errors, handle_domain_errors])

    resources = Resources(ApiProvider(domain))

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.post("/v1/submit_data/", resources.submit_data),
            web.post("/v1/show_preview/", resources.show_preview),
            web.post("/v1/submit_markup/", resources.submit_markup),
            web.post("/v1/import_clients/", resources.import_clients),
            web.post("/v1/fetch_pipeline_status/", resources.fetch_pipeline_status),
        ]
    )

    return api
