from aiohttp.web import Request, Response

from .providers import ApiProvider


class Resources:
    _provider: ApiProvider

    def __init__(self, provider: ApiProvider):
        self._provider = provider

    async def ping(self, _: Request) -> Response:
        return Response(status=204)

    async def submit_data(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.submit_data(data=body)

        return Response(status=200, body=result)

    async def show_preview(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.show_preview(data=body)

        return Response(status=200, body=result)

    async def submit_markup(self, request: Request) -> Response:
        body = await request.read()

        await self._provider.submit_markup(data=body)

        return Response(status=200)

    async def import_clients(self, request: Request) -> Response:
        body = await request.read()

        await self._provider.import_clients(data=body)

        return Response(status=200)

    async def fetch_pipeline_status(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.fetch_pipeline_status(data=body)

        return Response(status=200, body=result)
