from enum import Enum


class PipelineStep(Enum):
    PARSING_DATA = "PARSING_DATA"
    VALIDATING_DATA = "VALIDATING_DATA"
    IMPORTING_CLIENTS = "IMPORTING_CLIENTS"


class StepStatus(Enum):
    IN_PROGRESS = "IN_PROGRESS"
    FINISHED = "FINISHED"
    FAILED = "FAILED"


class InputDataType(Enum):
    TEXT = "TEXT"
    CSV_FILE = "CSV_FILE"
    XLSX_FILE = "XLSX_FILE"


class ColumnType(Enum):
    DO_NOT_IMPORT = "do_not_import"
    FIRST_NAME = "first_name"
    LAST_NAME = "last_name"
    PHONE = "phone"
    EMAIL = "email"
    COMMENT = "comment"


class FileExtension(Enum):
    CSV = "CSV"
    XLSX = "XLSX"
