PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aresponses
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    smb/common/testing_utils

    maps_adv/common/helpers
    maps_adv/common/lasagna/pytest
    maps_adv/geosmb/doorman/client/pytest
    maps_adv/geosmb/harmonist/server
)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/create_clients/__init__.py
    domain/__init__.py
    domain/submit_markup/__init__.py
    domain/parsers/__init__.py
    data_manager/__init__.py
    conftest.py
    factory.py
)

TEST_SRCS(
    api/create_clients/test_create_clients.py
    api/create_clients/test_from_csv_file.py
    api/create_clients/test_from_text.py
    api/create_clients/test_from_xlsx.py
    api/test_fetch_pipeline_status.py
    api/test_import_clients.py
    api/test_ping.py
    api/test_show_preview.py
    api/test_submit_markup.py
    domain/submit_markup/test_submit_markup.py
    domain/submit_markup/test_validate_data.py
    domain/parsers/test_csv_parser.py
    domain/parsers/test_xlsx_parser.py
    domain/test_fetch_pipeline_status.py
    domain/test_import_clients.py
    domain/test_processed_unimported.py
    domain/test_process_unvalidated.py
    domain/test_submit_data.py
    domain/test_lock_manager.py
    domain/test_show_preview.py
    domain/test_validator.py
    data_manager/test_fetch_clients_creation_log.py
    data_manager/test_list_unimported_creation_entries.py
    data_manager/test_list_unvalidated_creation_entries.py
    data_manager/test_submit_data.py
    data_manager/test_show_preview.py
    data_manager/test_submit_error_file.py
    data_manager/test_submit_import_result.py
    data_manager/test_submit_markup.py
    data_manager/test_submit_validated_clients.py
    data_manager/test_update_log_status.py
    tasks/test_tasks_warden_integration.py
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()


RESOURCE_FILES(
    PREFIX maps_adv/geosmb/harmonist/server/tests

    fixtures/xlsx/common.xlsx
    fixtures/xlsx/different_line_length.xlsx
    fixtures/xlsx/emptycell.xlsx
    fixtures/xlsx/formulas.xlsx
    fixtures/xlsx/twosheets.xlsx
)

END()
