import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.landlord.server.lib import Application

config = ConfigLoader(
    Option("DATABASE_URL"),
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option("TVM_SELF_ALIAS", default="self"),
    Option("BVM_URL", default=None),
    Option("MARKET_INT_URL", default=None),
    Option("GEOBASE_URL", default=None),
    Option("GEOSEARCH_URL", default=None),
    Option("GEOSEARCH_TVM_ID", default="geosearch"),
    Option("AVATARS_INSTALLATION", default="testing"),
    Option("AVATARS_STORE_NAMESPACE", default=None),
    Option("FETCH_DATA_TOKEN"),
    Option("BASE_MAPS_URL"),
    Option("BASE_WIDGET_REQUEST_URL"),
    Option("PROMOS_YT_TABLE", default=None),
    Option("GEOADV_ORGS_YT_TABLE", default=None),
    Option("GEOADV_CAMPAIGNS_YT_TABLE", default=None),
    Option("GEOADV_BASE_YT_PREFIX", default=None),
    Option("LANDLORD_BASE_YT_PREFIX", default=None),
    Option("MARKET_INT_STREAMING_YT_FOLDER", default=None),
    Option("YT_GOODS_TABLE", default=None),
    Option("YT_BIZ_STATE_TABLE", default=None),
    Option("YT_CLUSTER", default="hahn"),
    Option("YT_TOKEN", default=None),
    Option("YQL_TOKEN", default=None),
    Option("WARDEN_TASKS", default=(), converter=converters.Tuple()),
    Option("WARDEN_URL", default=None),
    Option("UGCDB_TVM_ID", default="ugcdb"),
    Option("UGCDB_URL", default=None),
    Option("AVATARS_UPLOAD_TIMEOUT", default=3),
    Option("TVM_WHITELIST", default=None, converter=converters.Tuple(element_converter=int)),
    Option(
        "TVM_DELETE_LANDING_WHITELIST",
        default=(),
        converter=converters.Tuple(element_converter=int),
    ),
    Option("DISABLE_PROMOTED_SERVICES", default=False, converter=converters.Bool()),
    Option(
        "YT_GOOGLE_COUNTERS_TABLE",
        default=None,
    ),
    Option(
        "YT_TIKTOK_PIXELS_TABLE",
        default=None,
    ),
    Option(
        "YT_VK_PIXELS_TABLE",
        default=None,
    ),
    Option("LANDING_CONFIG_BUNKER_NODE", default=None),
    Option("LANDING_CONFIG_BUNKER_NODE_VERSION", default=None),
    Option("BUNKER_URL", default=None),
    Option("TUNER_URL", default=None),
    Option("ENABLE_EXT_FEED_WRITER", default=False, converter=converters.Bool()),
    Option("LANDING_BASE_DOMAIN", default=None),
)

arg_parser = argparse.ArgumentParser("Landlord")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
