from aiohttp import web

from maps_adv.geosmb.landlord.server.lib.domain import Domain

from .middlewares import handle_domain_errors, handle_validation_errors
from .providers import ApiProvider
from .resources import Resources

__all__ = ["create"]


def create(domain: Domain) -> web.Application:
    api = web.Application(middlewares=[handle_validation_errors, handle_domain_errors])

    resources = Resources(ApiProvider(domain))

    api.add_routes([web.get("/ping", resources.ping)])
    api.add_routes(
        [
            web.post(
                "/external/fetch_landing_data/", resources.fetch_published_landing_data
            ),
            web.post("/external/get_landing_config/", resources.get_landing_config),
            web.post("/v1/get_landing_config/", resources.get_landing_config),
            web.post("/v1/fetch_landing_data/", resources.fetch_published_landing_data),
            web.post("/v1/generate_landing_data/", resources.generate_landing_data),
            web.post(
                "/v1/create_landing_from_data/", resources.create_landing_from_data
            ),
            web.post("/v1/delete_landing/", resources.delete_landing),
            web.post("/v1/check_slug_is_free/", resources.check_slug_is_free),
            web.post("/v1/update_slug/", resources.update_slug),
            web.post("/v1/edit_instagram_landing/", resources.edit_instagram_landing),
            web.post("/v1/set_landing_publicity/", resources.set_landing_publicity),
            web.post("/v1/set_blocked/", resources.set_blocked),
            web.post("/v1/show_landing_details/", resources.show_landing_details),
            web.post("/v1/edit_landing_details/", resources.edit_landing_details),
            web.get(r"/v1/suggests/color_presets/", resources.suggest_color_presets),
            web.post(r"/v1/suggests/{field:\w+}/", resources.suggest_field_values),
            web.get(r"/v1/fetch_landing_phone/", resources.fetch_landing_phone),
            web.post(r"/v1/fetch_landing_photos/", resources.fetch_landing_photos),
            web.post(r"/v1/hide_landing_photos/", resources.hide_landing_photos),
            web.post(r"/v1/get_landing_slug/", resources.get_landing_slug),
        ]
    )

    return api
