CREATE TABLE landing_data (
    id bigserial PRIMARY KEY,
    name text NOT NULL,
    categories text[] NOT NULL,
    description text,
    logo text,
    cover text,
    contacts jsonb NOT NULL,
    extras text[] NOT NULL DEFAULT '{}',
    preferences jsonb NOT NULL DEFAULT '{}',
    blocks_options jsonb NOT NULL DEFAULT '{}'
);

CREATE TABLE biz_state (
    id bigserial PRIMARY KEY,
    biz_id bigint NOT NULL,
    slug text NOT NULL,
    stable_version bigint REFERENCES landing_data,
    unstable_version bigint REFERENCES landing_data,
    published bool NOT NULL DEFAULT FALSE
);
CREATE UNIQUE INDEX biz_state_biz_id_uq ON biz_state USING btree (biz_id);
CREATE UNIQUE INDEX biz_state_slug_uq ON biz_state USING btree (slug);
