DROP TABLE promoted_service_lists;
DROP TABLE promoted_services;
DROP TABLE promotions;
DROP TABLE promoted_cta;

CREATE TABLE promoted_service_lists (
    id bigserial PRIMARY KEY,
    permalink bigint NOT NULL,
    services bigint[] NOT NULL
);

CREATE INDEX promoted_service_lists_permalink_btree ON promoted_service_lists USING btree (permalink);


CREATE TABLE promoted_services (
    id bigserial PRIMARY KEY,
    permalink bigint NOT NULL,
    title text NOT NULL,
    cost decimal,
    image text
);

CREATE INDEX promoted_services_permalink_btree ON promoted_services USING btree (permalink);

CREATE TABLE promotions (
    id bigserial PRIMARY KEY,
    permalink bigint NOT NULL,
    announcement text NOT NULL,
    description text NOT NULL,
    date_from text NOT NULL,
    date_to text NOT NULL,
    banner_img text,
    link text
);

CREATE INDEX promotions_permalink_btree ON promotions USING btree (permalink);


CREATE TABLE promoted_cta (
    id bigserial PRIMARY KEY,
    permalink bigint NOT NULL,
    title text NOT NULL,
    link text NOT NULL
);

CREATE INDEX promoted_cta_permalink_btree ON promoted_cta USING btree (permalink);
