DROP TABLE promoted_service_lists;
DROP TABLE promoted_services;
DROP TABLE promotions;
DROP TABLE promoted_cta;

CREATE TABLE promoted_service_lists (
    id bigserial PRIMARY KEY,
    list_id bigint NOT NULL,
    biz_id bigint NOT NULL,
    services bigint[] NOT NULL
);

CREATE INDEX promoted_service_lists_biz_id_btree ON promoted_service_lists USING btree (biz_id);


CREATE TABLE promoted_services (
    id bigserial PRIMARY KEY,
    service_id bigint NOT NULL,
    title text NOT NULL,
    cost decimal,
    image text
);

CREATE INDEX promoted_services_service_id_btree ON promoted_services USING btree (service_id);

CREATE TABLE promotions (
    id bigserial PRIMARY KEY,
    promotion_id bigint NOT NULL,
    biz_id bigint NOT NULL,
    announcement text NOT NULL,
    description text NOT NULL,
    date_from text NOT NULL,
    date_to text NOT NULL,
    banner_img text,
    link text
);

CREATE INDEX promotions_biz_id_btree ON promotions USING btree (biz_id);


CREATE TABLE promoted_cta (
    id bigserial PRIMARY KEY,
    cta_id bigint NOT NULL,
    biz_id bigint NOT NULL,
    title text NOT NULL,
    link text NOT NULL
);

CREATE INDEX promoted_cta_biz_id_btree ON promoted_cta USING btree (biz_id);
