PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aresponses
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    contrib/python/pytest-freezegun

    smb/common/pgswim/pytest
    smb/common/testing_utils

    maps_adv/common/lasagna/pytest
    maps_adv/common/ugcdb_client/pytest
    maps_adv/geosmb/clients/bunker/pytest
    maps_adv/geosmb/clients/bvm/pytest
    maps_adv/geosmb/clients/geosearch/pytest
    maps_adv/geosmb/clients/market/pytest

    maps_adv/geosmb/landlord/server
)

SRCDIR(maps_adv/geosmb/landlord/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/external/__init__.py
    api/external/fetch_published_landing_data/__init__.py
    api/external/fetch_published_landing_data/conftest.py
    api/internal/__init__.py
    api/internal/generate_landing_data/__init__.py
    api/internal/fetch_published_landing_data/__init__.py
    api/internal/fetch_published_landing_data/conftest.py
    api/internal/suggest_field/__init__.py
    conftest.py
    data_manager/__init__.py
    data_manager/fetch_promoted_data/__init__.py
    data_manager/import_from_yt/__init__.py
    domain/__init__.py
    domain/fetch_published_landing_data_by_slug/__init__.py
    domain/fetch_published_landing_data_by_slug/conftest.py
    domain/generate_data_for_biz_id/__init__.py
    domain/generate_data_for_biz_id/conftest.py
    domain/providers/__init__.py
    domain/suggest_fields/__init__.py
    factory.py
    shared_mock.py
    tasks/__init__.py
    async_yt_client/__init__.py
)

TEST_SRCS(
    api/external/fetch_published_landing_data/test_block_options.py
    api/external/fetch_published_landing_data/test_branches.py
    api/external/fetch_published_landing_data/test_contacts.py
    api/external/fetch_published_landing_data/test_fetch_data_by_slug.py
    api/external/fetch_published_landing_data/test_preferences.py
    api/external/fetch_published_landing_data/test_promos.py
    api/external/fetch_published_landing_data/test_rating.py
    api/external/fetch_published_landing_data/test_schedule.py
    api/external/fetch_published_landing_data/test_services.py
    api/external/test_get_landing_config.py
    api/internal/generate_landing_data/test_block_options_autogeneration.py
    api/internal/generate_landing_data/test_cta_button_autogeneration.py
    api/internal/generate_landing_data/test_generate_landing_data.py
    api/internal/generate_landing_data/test_logo_and_cover_handling.py
    api/internal/suggest_field/test_suggest_color_presets.py
    api/internal/suggest_field/test_suggests_categories.py
    api/internal/suggest_field/test_suggests_cta_button.py
    api/internal/suggest_field/test_suggests_plain_extras.py
    api/internal/test_check_slug_is_free.py
    api/internal/test_delete_landing.py
    api/internal/test_edit_instagram_landing.py
    api/internal/test_edit_landing_details.py
    api/internal/test_set_landing_publicity.py
    api/internal/test_show_landing_details.py
    api/internal/test_update_slug.py
    api/internal/test_set_blocked.py
    api/internal/test_fetch_landing_phone.py
    api/internal/test_fetch_landing_photos.py
    api/internal/test_hide_landing_photos.py
    api/internal/fetch_published_landing_data/test_block_options.py
    api/internal/fetch_published_landing_data/test_contacts.py
    api/internal/fetch_published_landing_data/test_fetch_data_by_slug.py
    api/internal/fetch_published_landing_data/test_promos.py
    api/internal/fetch_published_landing_data/test_rating.py
    api/internal/fetch_published_landing_data/test_schedule.py
    api/internal/fetch_published_landing_data/test_services.py
    api/internal/test_create_landing_from_data.py
    api/internal/test_get_landing_slug.py
    api/test_ping.py
    data_manager/fetch_promoted_data/test_fetch_org_promos.py
    data_manager/fetch_promoted_data/test_fetch_org_promoted_services.py
    data_manager/fetch_promoted_data/test_fetch_promoted_cta.py
    data_manager/fetch_promoted_data/test_fetch_substitution_phone.py
    data_manager/import_from_yt/test_import_avatars_from_yt.py
    data_manager/import_from_yt/test_import_call_tracking_from_yt.py
    data_manager/import_from_yt/test_import_promos_from_yt.py
    data_manager/import_from_yt/test_import_promoted_cta_from_yt.py
    data_manager/import_from_yt/test_import_promoted_service_lists_from_yt.py
    data_manager/import_from_yt/test_import_promoted_services_from_yt.py
    data_manager/import_from_yt/test_import_google_counters_from_yt.py
    data_manager/import_from_yt/test_import_market_int_services_from_yt.py
    data_manager/import_from_yt/test_import_goods_data_from_yt.py
    data_manager/import_from_yt/test_import_vk_pixels_from_yt.py
    data_manager/import_from_yt/test_sync_permalinks_from_yt.py
    data_manager/test_create_biz_state.py
    data_manager/test_delete_landing_by_biz_id.py
    data_manager/test_fetch_avatars.py
    data_manager/test_check_slug_is_free.py
    data_manager/test_fetch_biz_state.py
    data_manager/test_fetch_biz_state_with_alias.py
    data_manager/test_fetch_cached_landing_config.py
    data_manager/test_fetch_cached_landing_config_feature.py
    data_manager/test_fetch_google_counters_for_permalink.py
    data_manager/test_fetch_landing_data_by_slug.py
    data_manager/test_fetch_landing_data_for_crm.py
    data_manager/test_fetch_landing_photos.py
    data_manager/test_fetch_slugs.py
    data_manager/test_hide_landing_photos.py
    data_manager/test_save_instagram_landing.py
    data_manager/test_save_landing_data_for_biz_id.py
    data_manager/test_set_cached_landing_config.py
    data_manager/test_set_landing_publicity.py
    data_manager/test_update_biz_state_slug.py
    data_manager/test_update_biz_state_set_blocked.py
    data_manager/test_fetch_landing_phone.py
    data_manager/test_fetch_branches_for_permalink.py
    data_manager/test_update_landing_data_with_geosearch.py
    data_manager/test_update_landing_data_with_crm.py
    data_manager/test_update_instagram_landing_data_with_geosearch.py
    data_manager/test_fetch_org_market_int_services.py
    data_manager/test_fetch_vk_pixels_for_permalink.py
    data_manager/test_update_permalink_from_geosearch.py
    domain/fetch_published_landing_data_by_slug/test_block_options.py
    domain/fetch_published_landing_data_by_slug/test_contacts.py
    domain/fetch_published_landing_data_by_slug/test_fetch_data_by_slug.py
    domain/fetch_published_landing_data_by_slug/test_preferences.py
    domain/fetch_published_landing_data_by_slug/test_promos.py
    domain/fetch_published_landing_data_by_slug/test_rating.py
    domain/fetch_published_landing_data_by_slug/test_schedule.py
    domain/fetch_published_landing_data_by_slug/test_services.py
    domain/fetch_published_landing_data_by_slug/test_branches.py
    domain/fetch_published_landing_data_by_slug/test_goods_data.py
    domain/generate_data_for_biz_id/test_block_options_autogeneration.py
    domain/generate_data_for_biz_id/test_cta_button_autogeneration.py
    domain/generate_data_for_biz_id/test_generate_data_for_biz_id.py
    domain/generate_data_for_biz_id/test_logo_and_cover_handling.py
    domain/generate_data_for_biz_id/test_slug_generation.py
    domain/providers/test_rating_provider.py
    domain/providers/test_service_provider.py
    domain/suggest_fields/test_suggest_cta_button.py
    domain/suggest_fields/test_suggest_field_values.py
    domain/test_check_slug_if_free.py
    domain/test_delete_landing_by_biz_id.py
    domain/test_fetch_landing_data_for_crm.py
    domain/test_get_landing_config.py
    domain/test_landing_photos.py
    domain/test_push_landing_urls_to_ext_feed_lb.py
    domain/test_set_landing_publicity.py
    domain/test_slug_maker.py
    domain/test_update_biz_state_slug.py
    domain/test_update_landing_config.py
    domain/test_update_landing_data_from_crm.py
    domain/test_update_biz_state_set_blocked.py
    domain/test_fetch_landing_phone.py
    domain/test_edit_instagram_landing.py
    domain/test_update_geosearch_data.py
    domain/test_create_landing_from_data.py
    domain/test_get_landing_slug.py
    tasks/test_avatars_yt_import.py
    tasks/test_call_tracking_yt_import.py
    tasks/test_promos_yt_import.py
    tasks/test_promoted_cta_yt_import.py
    tasks/test_promoted_service_lists_yt_import.py
    tasks/test_promoted_services_yt_import.py
    tasks/test_tasks_warden_integration.py
    tasks/test_google_counters_yt_import.py
    tasks/test_market_int_services_import.py
    tasks/test_tiktok_pixels_yt_import.py
    tasks/test_goods_data_import.py
    tasks/test_vk_pixels_import.py
    tasks/test_sync_permalinks.py
    async_yt_client/test_async_yt_client.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://landlord:landlord@localhost:5433/landlord)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()

END()
