PY3_LIBRARY()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/frozendict
    contrib/python/transliterate

    robot/protos/crawl/compatibility

    smb/common/http_client
    smb/common/multiruntime
    maps_adv/common/avatars
    maps_adv/common/config_loader
    maps_adv/common/lasagna
    maps_adv/common/ugcdb_client
    maps_adv/common/yt_utils
    maps_adv/geosmb/clients/bunker
    maps_adv/geosmb/clients/bvm
    maps_adv/geosmb/clients/geobase
    maps_adv/geosmb/clients/geosearch
    maps_adv/geosmb/clients/logbroker
    maps_adv/geosmb/clients/market
    maps_adv/geosmb/landlord/proto
    maps_adv/geosmb/tuner/client
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers.py
    lib/api/resources.py
    lib/data_manager.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/domain/__init__.py
    lib/domain/domain.py
    lib/domain/rating_provider.py
    lib/domain/service_provider.py
    lib/domain/slug_maker.py
    lib/domain/suggester.py
    lib/async_yt_client.py
    lib/enums.py
    lib/exceptions.py
    lib/ext_feed_lb_writer.py
    lib/sqls.py
    lib/timing.py
    lib/tasks/__init__.py
    lib/tasks/yqls.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/landlord/server/
    lib/db/migrations/001_20201007/upgrade.sql
    lib/db/migrations/001_20201007/downgrade.sql
    lib/db/migrations/002_20201118/upgrade.sql
    lib/db/migrations/002_20201118/downgrade.sql
    lib/db/migrations/003_20201126/upgrade.sql
    lib/db/migrations/003_20201126/downgrade.sql
    lib/db/migrations/004_20201130/upgrade.sql
    lib/db/migrations/004_20201130/downgrade.sql
    lib/db/migrations/005_20201201/upgrade.sql
    lib/db/migrations/005_20201201/downgrade.sql
    lib/db/migrations/006_20201215/upgrade.sql
    lib/db/migrations/006_20201215/downgrade.sql
    lib/db/migrations/007_20201228/upgrade.sql
    lib/db/migrations/007_20201228/downgrade.sql
    lib/db/migrations/008_20210224/upgrade.sql
    lib/db/migrations/008_20210224/downgrade.sql
    lib/db/migrations/009_20210318/upgrade.sql
    lib/db/migrations/009_20210318/downgrade.sql
    lib/db/migrations/010_20210406/upgrade.sql
    lib/db/migrations/010_20210406/downgrade.sql
    lib/db/migrations/011_20210413/upgrade.sql
    lib/db/migrations/011_20210413/downgrade.sql
    lib/db/migrations/012_20210426/upgrade.sql
    lib/db/migrations/012_20210426/downgrade.sql
    lib/db/migrations/013_20210625/upgrade.sql
    lib/db/migrations/013_20210625/downgrade.sql
    lib/db/migrations/014_20210706/upgrade.sql
    lib/db/migrations/014_20210706/downgrade.sql
    lib/db/migrations/015_20210720/upgrade.sql
    lib/db/migrations/015_20210720/downgrade.sql
    lib/db/migrations/016_20210827/upgrade.sql
    lib/db/migrations/016_20210827/downgrade.sql
    lib/db/migrations/017_20210922/upgrade.sql
    lib/db/migrations/017_20210922/downgrade.sql
    lib/db/migrations/018_20211102/upgrade.sql
    lib/db/migrations/018_20211102/downgrade.sql
    lib/db/migrations/019_20211123/upgrade.sql
    lib/db/migrations/019_20211123/downgrade.sql
    lib/db/migrations/020_20211125/upgrade.sql
    lib/db/migrations/020_20211125/downgrade.sql
    lib/db/migrations/021_20211202/upgrade.sql
    lib/db/migrations/021_20211202/downgrade.sql
    lib/db/migrations/022_20220111/upgrade.sql
    lib/db/migrations/022_20220111/downgrade.sql
    lib/db/migrations/023_20220303/upgrade.sql
    lib/db/migrations/023_20220303/downgrade.sql
    lib/db/migrations/024_20220317/upgrade.sql
    lib/db/migrations/024_20220317/downgrade.sql
    lib/db/migrations/025_20220527/upgrade.sql
    lib/db/migrations/025_20220527/downgrade.sql
    lib/db/migrations/026_20220531/upgrade.sql
    lib/db/migrations/026_20220531/downgrade.sql
    lib/db/migrations/027_20220617/upgrade.sql
    lib/db/migrations/027_20220617/downgrade.sql
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
