import argparse

from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.logoped.server.lib import Application

arg_parser = argparse.ArgumentParser("Logoped")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()

    args = arg_parser.parse_args()

    app = Application({})
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
