from aiohttp import web
from smb.common.multiruntime.lib import is_arcadia_python

from maps_adv.common.lasagna import Lasagna

from . import api


class Application(Lasagna):
    SWIM_ENGINE_CLS = None

    async def _setup_layers(self, db: None) -> web.Application:
        return api.create()

    def run(self, *args, **kwargs) -> None:
        if not is_arcadia_python:
            raise RuntimeError("Server can work only in arcadia")
        return super().run(*args, **kwargs)
