PY3_LIBRARY()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/aioitertools
    contrib/python/marshmallow/py2
    contrib/python/pytz

    smb/common/multiruntime
    maps_adv/common/lasagna
    maps_adv/common/yt_utils
    maps_adv/geosmb/clients/bvm
    maps_adv/geosmb/clients/cdp
    maps_adv/geosmb/clients/geosearch
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers.py
    lib/api/resources.py
    lib/data_manager.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/domain.py
    lib/enums.py
    lib/exceptions.py
    lib/sqls.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/marksman/server/

    lib/db/migrations/001_20210304/upgrade.sql
    lib/db/migrations/001_20210304/downgrade.sql
    lib/db/migrations/002_20210305/upgrade.sql
    lib/db/migrations/002_20210305/downgrade.sql
    lib/db/migrations/003_20210316/upgrade.sql
    lib/db/migrations/003_20210316/downgrade.sql
    lib/db/migrations/004_20210317/upgrade.sql
    lib/db/migrations/004_20210317/downgrade.sql
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
