from aiohttp import web
from smb.common.pgswim import SwimEngine

from ..domain import Domain
from .middlewares import handle_domain_errors, handle_validation_errors
from .resources import Resources

__all__ = ["create"]


def create(domain: Domain, db: SwimEngine) -> web.Application:
    api = web.Application(middlewares=[handle_domain_errors, handle_validation_errors])

    resources = Resources(domain, db)

    api.add_routes([web.get("/ping", resources.ping)])
    api.add_routes(
        [
            web.post("/v1/business/", resources.add_business),
            web.get(
                "/v1/business/segments_data/", resources.list_business_segments_data
            ),
        ]
    )

    return api
